% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05-search.R
\name{ons_search}
\alias{ons_search}
\title{Search for a Dataset}
\usage{
ons_search(id, edition = NULL, version = NULL, name = NULL, query = NULL)
}
\arguments{
\item{id}{\verb{[character]}     Id that represents a dataset.}

\item{edition}{\verb{[character]}     A subset of the dataset representing a specific time period.
For some datasets this edition can contain all time periods (all historical data).
The latest version of this is displayed by default.}

\item{version}{\verb{[character]}     A specific instance of the edition at a point in time. New
versions can be published as a result of corrections, revisions or new data
becoming available.}

\item{name}{\verb{[character]}. The name of dimension to perform the query. Available dimensions for
a specific id at \code{ons_dim()}.}

\item{query}{\verb{[character]}. The query.}
}
\value{
A data.frame.
}
\description{
Search for a Dataset
}
\examples{
\donttest{
ons_dim("cpih01")
ons_search("cpih01", name = "aggregate", query = "cpih1dim1A0")
}
}
