% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodSuppress.R
\name{suppress.summarised_result}
\alias{suppress.summarised_result}
\title{Function to suppress counts in result objects}
\usage{
\method{suppress}{summarised_result}(result, minCellCount = 5)
}
\arguments{
\item{result}{summarised_result object.}

\item{minCellCount}{Minimum count of records to report results.}
}
\value{
summarised_result with suppressed counts.
}
\description{
Function to suppress counts in result objects
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(omopgenerics)

my_result <- tibble(
  "result_id" = "1",
  "cdm_name" = "mock",
  "result_type" = "summarised_characteristics",
  "package_name" = "omopgenerics",
  "package_version" = as.character(utils::packageVersion("omopgenerics")),
  "group_name" = "overall",
  "group_level" = "overall",
  "strata_name" = c(rep("overall", 6), rep("sex", 3)),
  "strata_level" = c(rep("overall", 6), "male", "female", "female"),
  "variable_name" = c("number records", "age_group", "age_group",
  "age_group", "age_group", "my_variable", "number records", "age_group",
  "age_group"),
  "variable_level" = c(NA, "<50", "<50", ">=50", ">=50", NA, NA,
  "<50", "<50"),
  "estimate_name" = c("count", "count", "percentage", "count", "percenatge",
  "random", "count", "count", "percentage"),
  "estimate_type" = c("integer", "integer", "percentage", "integer",
  "percentage", "numeric", "integer", "integer", "percentage"),
  "estimate_value" = c("10", "5", "50", "3", "30", "1", "3", "12", "6"),
  "additional_name" = "overall",
  "additional_level" = "overall"
)
my_result <- newSummarisedResult(my_result)
my_result |> glimpse()
my_result <- suppress(my_result, minCellCount = 5)
my_result |> glimpse()

}
