% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-studentized-residual-chart.R
\name{ols_srsd_chart}
\alias{ols_srsd_chart}
\title{Standardized Residual Chart}
\usage{
ols_srsd_chart(model)
}
\arguments{
\item{model}{an object of class \code{lm}}
}
\value{
\code{ols_srsd_chart} returns  a list containing the
following components:

\item{outliers}{a tibble with observation number and \code{standardized resiudals} that 
exceed \code{threshold}} for classifying an observation as an outlier
\item{threshold}{\code{threshold} for classifying an observation as an outlier}
}
\description{
Chart for identifying outliers
}
\details{
Standardized residual (internally studentized) is the residual divided by estimated 
standard deviation.
}
\examples{
model <- lm(mpg ~ disp + hp + wt, data = mtcars)
ols_srsd_chart(model)
}
