% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrapers.R
\name{get_articles_from_search}
\alias{get_articles_from_search}
\title{Scraps OJS search results for a given criteria and retrieves the articles' url}
\usage{
get_articles_from_search(input_url, search_criteria, verbose = FALSE)
}
\arguments{
\item{input_url}{Character vector.}

\item{search_criteria}{Character string}

\item{verbose}{Logical.}
}
\value{
A dataframe with the urls of the articles linked from the OJS issue page.
}
\description{
Takes a vector of OJS urls, process them to create search result pages (including pagination)
and scraps them to retrieve links to OJS articles
}
\examples{
\donttest{
journals <- c(
   'https://revistapsicologia.uchile.cl/index.php/RDP/',
   'https://publicaciones.sociales.uba.ar/index.php/psicologiasocial/'
)
criteria <- "actitudes"
search_result_pages <- ojsr::get_articles_from_search(input_url = journals,
    search_criteria = criteria, verbose = TRUE)
}
}
