% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_add.R
\name{body_add_fpar}
\alias{body_add_fpar}
\title{Add fpar in a 'Word' document}
\usage{
body_add_fpar(x, value, style = NULL, pos = "after")
}
\arguments{
\item{x}{a docx device}

\item{value}{a character}

\item{style}{paragraph style. If NULL, paragraph settings from \code{fpar} will be used. If not
NULL, it must be a paragraph style name (located in the template
provided as \code{read_docx(path = ...)}); in that case, paragraph settings from \code{fpar} will be
ignored.}

\item{pos}{where to add the new element relative to the cursor,
one of "after", "before", "on".}
}
\description{
Add an \code{fpar} (a formatted paragraph)
into an rdocx object.
}
\examples{
bold_face <- shortcuts$fp_bold(font.size = 30)
bold_redface <- update(bold_face, color = "red")
fpar_ <- fpar(
  ftext("Hello ", prop = bold_face),
  ftext("World", prop = bold_redface),
  ftext(", how are you?", prop = bold_face)
)
doc <- read_docx()
doc <- body_add_fpar(doc, fpar_)

print(doc, target = tempfile(fileext = ".docx"))

# a way of using fpar to center an image in a Word doc ----
rlogo <- file.path(R.home("doc"), "html", "logo.jpg")
img_in_par <- fpar(
  external_img(src = rlogo, height = 1.06 / 2, width = 1.39 / 2),
  hyperlink_ftext(
    href = "https://cran.r-project.org/index.html",
    text = "cran", prop = bold_redface
  ),
  fp_p = fp_par(text.align = "center")
)

doc <- read_docx()
doc <- body_add_fpar(doc, img_in_par)
print(doc, target = tempfile(fileext = ".docx"))

}
\seealso{
\code{\link{fpar}}

Other functions for adding content: 
\code{\link{body_add_blocks}()},
\code{\link{body_add_break}()},
\code{\link{body_add_caption}()},
\code{\link{body_add_docx}()},
\code{\link{body_add_gg}()},
\code{\link{body_add_img}()},
\code{\link{body_add_par}()},
\code{\link{body_add_plot}()},
\code{\link{body_add_table}()},
\code{\link{body_add_toc}()}
}
\concept{functions for adding content}
