% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_pptx.R
\name{slide_summary}
\alias{slide_summary}
\title{get PowerPoint slide content in a tidy format}
\usage{
slide_summary(x, index = NULL)
}
\arguments{
\item{x}{rpptx object}

\item{index}{slide index}
}
\description{
get content and positions of current slide
into a data.frame. Data for any tables, images, or paragraphs are
imported into the resulting data.frame.
}
\note{
The column \code{id} of the result is not to be used by users.
This is a technical string id whose value will be used by office
when the document will be rendered. This is not related to argument
\code{index} required by functions \code{ph_with_zzz}.
}
\examples{
library(magrittr)

my_pres <- read_pptx() \%>\%
  add_slide(layout = "Two Content", master = "Office Theme") \%>\%
  ph_with_text(type = "dt", str = format(Sys.Date())) \%>\%
  add_slide(layout = "Title and Content", master = "Office Theme")

slide_summary(my_pres)
slide_summary(my_pres, index = 1)
}
