% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_add.R
\name{body_add_docx}
\alias{body_add_docx}
\title{insert an external docx}
\usage{
body_add_docx(x, src, pos = "after")
}
\arguments{
\item{x}{an rdocx object}

\item{src}{docx filename}

\item{pos}{where to add the new element relative to the cursor,
one of "after", "before", "on".}
}
\description{
add content of a docx into an rdocx object.
}
\note{
The function is using a 'Microsoft Word' feature: when the
document will be edited, the content of the file will be
inserted in the main document.

This feature is unlikely to work as expected if the
resulting document is edited by another software.
}
\examples{

library(magrittr)
file1 <- tempfile(fileext = ".docx")
file2 <- tempfile(fileext = ".docx")
file3 <- tempfile(fileext = ".docx")
read_docx() \%>\%
  body_add_par("hello world 1", style = "Normal") \%>\%
  print(target = file1)
read_docx() \%>\%
  body_add_par("hello world 2", style = "Normal") \%>\%
  print(target = file2)

read_docx(path = file1) \%>\%
  body_add_break() \%>\%
  body_add_docx(src = file2) \%>\%
  print(target = file3)
}
\seealso{
Other functions for adding content: 
\code{\link{body_add_blocks}()},
\code{\link{body_add_break}()},
\code{\link{body_add_caption}()},
\code{\link{body_add_fpar}()},
\code{\link{body_add_gg}()},
\code{\link{body_add_img}()},
\code{\link{body_add_par}()},
\code{\link{body_add_plot}()},
\code{\link{body_add_table}()},
\code{\link{body_add_toc}()}
}
\concept{functions for adding content}
