% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connection.R
\name{odbcConnectionColumns}
\alias{odbcConnectionColumns}
\alias{odbcConnectionColumns,OdbcConnection,Id-method}
\alias{odbcConnectionColumns,OdbcConnection,character-method}
\alias{odbcConnectionColumns,OdbcConnection,SQL-method}
\title{odbcConnectionColumns}
\usage{
odbcConnectionColumns(conn, name, ...)

\S4method{odbcConnectionColumns}{OdbcConnection,Id}(conn, name, column_name = NULL)

\S4method{odbcConnectionColumns}{OdbcConnection,character}(
  conn,
  name,
  catalog_name = NULL,
  schema_name = NULL,
  column_name = NULL
)

\S4method{odbcConnectionColumns}{OdbcConnection,SQL}(conn, name, ...)
}
\arguments{
\item{conn}{OdbcConnection}

\item{name}{table we wish to get information on}

\item{...}{additional parameters to methods}

\item{column_name}{The name of the column to return, the default returns all columns.}

\item{catalog_name}{character catalog where the table is located}

\item{schema_name}{character schema where the table is located}
}
\value{
data.frame with columns
\itemize{
\item name
\item field.type - equivalent to type_name in SQLColumns output
\item table_name
\item schema_name
\item catalog_name
\item data_type
\item column_size
\item buffer_length
\item decimal_digits
\item numeric_precision_radix
\item column_default
\item sql_data_type
\item sql_datetime_subtype
\item char_octet_length
\item ordinal_position
\item nullable
}
}
\description{
For a given table this function returns detailed information on
all fields / columns.  The expectation is that this is a relatively thin
wrapper around the ODBC \code{SQLColumns} function call, with some of the field names
renamed / re-ordered according to the return specifications below.
}
\details{
In \code{\link[=dbWriteTable]{dbWriteTable()}} we make a call to this method
to get details on the fields of the table we are writing to.  In particular
the columns \code{data_type}, \code{column_size}, and \code{decimal_digits} are used.  An
implementation is not necessary for \code{\link[=dbWriteTable]{dbWriteTable()}} to work.

\code{odbcConnectionColumns} is routed through the \code{SQLColumns} ODBC
method.  This function, together with remaining catalog functions
(\code{SQLTables}, etc), by default ( \code{SQL_ATTR_METADATA_ID == false} ) expect
either ordinary arguments (OA) in the case of the catalog, or pattern value
arguments (PV) in the case of schema/table name.  For these, quoted
identifiers do not make sense, so we unquote identifiers prior to the call.
}
\seealso{
The ODBC documentation on \href{https://docs.microsoft.com/en-us/sql/odbc/reference/syntax/sqlcolumns-function}{SQLColumns}
for further details.

The ODBC documentation on \href{https://learn.microsoft.com/en-us/sql/odbc/reference/develop-app/arguments-in-catalog-functions?view=sql-server-ver16}{Arguments to catalog functions}.
}
