% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{ctimeToSeconds}
\alias{ctimeToSeconds}
\title{Interpret a character string as a time interval}
\usage{
ctimeToSeconds(ctime)
}
\arguments{
\item{ctime}{a character string (see \dQuote{Details}.}
}
\value{
A numeric value, the number of seconds represented by the string.
}
\description{
Interpret a character string as a time interval
Strings are of the form MM:SS or HH:MM:SS.
}
\examples{
library(oce)
cat("10      = ", ctimeToSeconds("10"), "s\n", sep="")
cat("01:04   = ", ctimeToSeconds("01:04"), "s\n", sep="")
cat("1:00:00 = ", ctimeToSeconds("1:00:00"), "s\n", sep="")
}
\seealso{
See \code{\link[=secondsToCtime]{secondsToCtime()}}, the inverse of this.

Other things related to time: 
\code{\link{julianCenturyAnomaly}()},
\code{\link{julianDay}()},
\code{\link{numberAsHMS}()},
\code{\link{numberAsPOSIXct}()},
\code{\link{secondsToCtime}()},
\code{\link{unabbreviateYear}()}
}
\author{
Dan Kelley
}
\concept{things related to time}
