% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lisst.R
\name{read.lisst}
\alias{read.lisst}
\title{Read a LISST File}
\usage{
read.lisst(
  file,
  year = 0,
  tz = "UTC",
  longitude = NA,
  latitude = NA,
  encoding = "latin1"
)
}
\arguments{
\item{file}{a connection or a character string giving the name of the file
to load.}

\item{year}{year in which the measurement of the series was made.}

\item{tz}{time zone.}

\item{longitude}{longitude of observation (stored in metadata)}

\item{latitude}{latitude of observation (stored in metadata)}

\item{encoding}{a character value that indicates the encoding to be used for
this data file, if it is textual.  The default value for most functions is
\code{"latin1"}, which seems to be suitable for files containing text written in
English and French.}
}
\value{
x A \linkS4class{lisst} object.
}
\description{
Read a LISST data file.
The file should contain 42 columns, with no header.  If there are fewer than
42 columns, an error results.  If there are more, only the first 42 are
used.  Note that \code{\link[=read.oce]{read.oce()}} can recognize LISST files by their
having a name ending in \code{".asc"} and by having 42 elements on the first
line.  Even so, it is preferred to use the present function, because it
gives the opportunity to specify the year and timezone, so that times can be
calculated properly.
}
\seealso{
Other things related to lisst data: 
\code{\link{[[,lisst-method}},
\code{\link{[[<-,lisst-method}},
\code{\link{as.lisst}()},
\code{\link{lisst-class}},
\code{\link{plot,lisst-method}},
\code{\link{summary,lisst-method}}
}
\author{
Dan Kelley
}
\concept{things related to lisst data}
