% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adp.nortek.R
\name{ad2cpHeaderValue}
\alias{ad2cpHeaderValue}
\title{Decode an item from a Nortek AD2CP file header}
\usage{
ad2cpHeaderValue(x, key, item, numeric = TRUE, default)
}
\arguments{
\item{x}{an \linkS4class{adp} object that holds AD2CP data.}

\item{key}{Character value that identifies a particular line in \code{x[["text"]]}.}

\item{item}{Character value indicating the name of the item sought.}

\item{numeric}{Logical value indicating whether to convert the return value
from a string to a numerical value.}

\item{default}{Optional value to be used if the item is not found in the
header, or if the header is \code{NULL} (as in the case of a split-up file
that lacks the initial header information)}
}
\value{
String or number interpreted from the \code{x[["text"]]}, or \code{NULL},
if the desired item is not found there, or if \code{x} is not of the required
class and variety.
}
\description{
Decode an item from a Nortek AD2CP file header
}
\examples{
\dontrun{
d <- read.oce("a.ad2cp")
# The examples start with the line in x[["text"]][[1]]; note that in the second
# example, it would be insuficient to use a key of "BEAMCFGLIST", because that will
# yield 4 lines, and the function is not designed to handle that.

# ID,STR=\"Signature1000\",SN=123456
type <- ad2cpHeaderValue(d, "ID", "STR", numeric=FALSE)
serialNumber <- ad2cpHeaderValue(d, "ID", "SN")

# BEAMCFGLIST,BEAM=1,THETA=25.00,PHI=0.00,FREQ=1000,BW=25,BRD=1,HWBEAM=1,ZNOM=60.00
beam1Angle <- ad2cpHeaderValue(d, "BEAMCFGLIST,BEAM=1", "THETA")
frequency <- ad2cpHeaderValue(d, "BEAMCFGLIST,BEAM=1", "FREQ", default=NA)
}

}
\seealso{
Other things related to adp data: 
\code{\link{[[,adp-method}},
\code{\link{[[<-,adp-method}},
\code{\link{adp-class}},
\code{\link{adpConvertRawToNumeric}()},
\code{\link{adpEnsembleAverage}()},
\code{\link{adpFlagPastBoundary}()},
\code{\link{adp_rdi.000}},
\code{\link{adp}},
\code{\link{as.adp}()},
\code{\link{beamName}()},
\code{\link{beamToXyzAdpAD2CP}()},
\code{\link{beamToXyzAdp}()},
\code{\link{beamToXyzAdv}()},
\code{\link{beamToXyz}()},
\code{\link{beamUnspreadAdp}()},
\code{\link{binmapAdp}()},
\code{\link{enuToOtherAdp}()},
\code{\link{enuToOther}()},
\code{\link{handleFlags,adp-method}},
\code{\link{is.ad2cp}()},
\code{\link{plot,adp-method}},
\code{\link{read.adp.ad2cp}()},
\code{\link{read.adp.nortek}()},
\code{\link{read.adp.rdi}()},
\code{\link{read.adp.sontek.serial}()},
\code{\link{read.adp.sontek}()},
\code{\link{read.adp}()},
\code{\link{read.aquadoppHR}()},
\code{\link{read.aquadoppProfiler}()},
\code{\link{read.aquadopp}()},
\code{\link{rotateAboutZ}()},
\code{\link{setFlags,adp-method}},
\code{\link{subset,adp-method}},
\code{\link{subtractBottomVelocity}()},
\code{\link{summary,adp-method}},
\code{\link{toEnuAdp}()},
\code{\link{toEnu}()},
\code{\link{velocityStatistics}()},
\code{\link{xyzToEnuAdpAD2CP}()},
\code{\link{xyzToEnuAdp}()},
\code{\link{xyzToEnu}()}
}
\concept{things related to adp data}
