% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{rescale}
\alias{rescale}
\title{Rescale values to lie in a given range}
\usage{
rescale(x, xlow, xhigh, rlow = 0, rhigh = 1, clip = TRUE)
}
\arguments{
\item{x}{a numeric vector.}

\item{xlow}{\code{x} value to correspond to \code{rlow}.  If not given, it
will be calculated as the minimum value of \code{x}}

\item{xhigh}{\code{x} value to correspond to \code{rhigh}.  If not given, it
will be calculated as the maximum value of \code{x}}

\item{rlow}{value of the result corresponding to \code{x} equal to
\code{xlow}.}

\item{rhigh}{value of the result corresponding to \code{x} equal to
\code{xhigh}.}

\item{clip}{logical, set to \code{TRUE} to clip the result to the range
spanned by \code{rlow} and \code{rhigh}.}
}
\value{
A new vector, which has minimum \code{lim[1]} and maximum \code{lim[2]}.
}
\description{
This is helpful in e.g. developing a color scale for an image plot.  It is
not necessary that \code{rlow} be less than \code{rhigh}, and in fact
reversing them is a good way to get a reversed color scale for a plot.
}
\examples{
library(oce)
# Fake tow-yow data
t <- seq(0, 600, 5)
x <- 0.5 * t
z <- 50 * (-1 + sin(2 * pi * t / 360))
T <- 5 + 10 * exp(z / 100)
palette <- oce.colorsJet(100)
zlim <- range(T)
drawPalette(zlim=zlim, col=palette)
plot(x, z, type='p', pch=20, cex=3,
     col=palette[rescale(T, xlow=zlim[1], xhigh=zlim[2], rlow=1, rhigh=100)])
}
\author{
Dan Kelley
}
