% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xbt.R
\name{plot,xbt-method}
\alias{plot,xbt-method}
\alias{plot.xbt}
\title{Plot An xbt data}
\usage{
\S4method{plot}{xbt}(
  x,
  which = 1,
  type = "l",
  mgp = getOption("oceMgp"),
  mar,
  debug = getOption("oceDebug"),
  ...
)
}
\arguments{
\item{x}{an \linkS4class{xbt} object.}

\item{which}{list of desired plot types; see \dQuote{Details} for the meanings of various
values of \code{which}.}

\item{type}{type of plot, as for \code{\link[=plot]{plot()}}.}

\item{mgp}{3-element numerical vector to use for \code{par(mgp)}, and also for
\code{par(mar)}, computed from this.  The default is tighter than the R default,
in order to use more space for the data and less for the axes.}

\item{mar}{value to be used with \code{\link{par}}\code{("mar")}.}

\item{debug}{a flag that turns on debugging.  Set to 1 to get a moderate amount
of debugging information, or to 2 to get more.}

\item{...}{optional arguments passed to plotting functions.}
}
\description{
Plots data contained in an \linkS4class{xbt} object.
}
\details{
The panels are controlled by the \code{which} argument, with choices as follows.
\itemize{
\item \code{which=1} for a temperature profile as a function of depth.
\item \code{which=2} for a soundSpeed profile as a function of depth.
}
}
\examples{
library(oce)
data(xbt)
summary(xbt)
plot(xbt)

}
\seealso{
Other functions that plot oce data: 
\code{\link{plot,adp-method}},
\code{\link{plot,adv-method}},
\code{\link{plot,amsr-method}},
\code{\link{plot,argo-method}},
\code{\link{plot,bremen-method}},
\code{\link{plot,cm-method}},
\code{\link{plot,coastline-method}},
\code{\link{plot,ctd-method}},
\code{\link{plot,gps-method}},
\code{\link{plot,ladp-method}},
\code{\link{plot,landsat-method}},
\code{\link{plot,lisst-method}},
\code{\link{plot,lobo-method}},
\code{\link{plot,met-method}},
\code{\link{plot,odf-method}},
\code{\link{plot,rsk-method}},
\code{\link{plot,satellite-method}},
\code{\link{plot,sealevel-method}},
\code{\link{plot,section-method}},
\code{\link{plot,tidem-method}},
\code{\link{plot,topo-method}},
\code{\link{plot,windrose-method}},
\code{\link{plotProfile}()},
\code{\link{plotScan}()},
\code{\link{plotTS}()},
\code{\link{tidem-class}}

Other things related to xbt data: 
\code{\link{[[,xbt-method}},
\code{\link{[[<-,xbt-method}},
\code{\link{as.xbt}()},
\code{\link{read.xbt.noaa1}()},
\code{\link{read.xbt}()},
\code{\link{subset,xbt-method}},
\code{\link{summary,xbt-method}},
\code{\link{xbt-class}},
\code{\link{xbt.edf}},
\code{\link{xbt}}
}
\author{
Dan Kelley
}
\concept{functions that plot oce data}
\concept{things related to xbt data}
