% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{mapAxis}
\alias{mapAxis}
\title{Add Axis Labels to an Existing Map}
\usage{
mapAxis(
  side = 1:2,
  longitude = TRUE,
  latitude = TRUE,
  tick = TRUE,
  line = NA,
  pos = NA,
  outer = FALSE,
  font = NA,
  lty = "solid",
  lwd = 1,
  lwd.ticks = lwd,
  col = NULL,
  col.ticks = NULL,
  hadj = NA,
  padj = NA,
  tcl = -0.3,
  cex.axis = 1,
  mgp = c(0, 0.5, 0),
  debug = getOption("oceDebug")
)
}
\arguments{
\item{side}{the side at which labels are to be drawn.  If not provided,
sides 1 and 2 will be used (i.e. bottom and left-hand sides).}

\item{longitude}{either a logical value or a vector of longitudes. There
are three possible cases:
(1) If \code{longitude=TRUE} (the default) then ticks and nearby numbers will occur at the
longitude grid established by the previous call to \code{\link[=mapPlot]{mapPlot()}};
(2) if \code{longitude=FALSE} then no longitude ticks or numbers are
drawn;
(3) if \code{longitude} is a vector of numerical values, then those ticks
are placed at those values, and numbers are written beside them.
Note that in cases 1 and 3, efforts are made to avoid overdrawing text,
so some longitude values might get ticks but not numbers. To get ticks
but not numbers, set \code{cex.axis=0}.}

\item{latitude}{similar to \code{longitude} but for latitude.}

\item{tick}{parameter passed to \code{\link[=axis]{axis()}}.}

\item{line}{parameter passed to \code{\link[=axis]{axis()}}.}

\item{pos}{parameter passed to \code{\link[=axis]{axis()}}.}

\item{outer}{parameter passed to \code{\link[=axis]{axis()}}.}

\item{font}{axis font, passed to \code{\link[=axis]{axis()}}.}

\item{lty}{axis line type, passed to \code{\link[=axis]{axis()}}.}

\item{lwd}{axis line width, passed to \code{\link[=axis]{axis()}}).}

\item{lwd.ticks}{tick line width, passed to \code{\link[=axis]{axis()}}.}

\item{col}{axis color, passed to \code{\link[=axis]{axis()}}.}

\item{col.ticks}{axis tick color, passed to \code{\link[=axis]{axis()}}.}

\item{hadj}{an argument that is transmitted to \code{\link[=axis]{axis()}}.}

\item{padj}{an argument that is transmitted to \code{\link[=axis]{axis()}}.}

\item{tcl}{axis-tick size (see \code{\link[=par]{par()}}).}

\item{cex.axis}{axis-label expansion factor (see \code{\link[=par]{par()}}); set to 0
to prevent numbers from being placed in axes.}

\item{mgp}{three-element numerical vector describing axis-label
placement (see \code{\link[=par]{par()}}). It usually makes sense to set
the first and third elements to zero.}

\item{debug}{a flag that turns on debugging.  Set to 1 to get a moderate
amount of debugging information, or to 2 to get more.}
}
\description{
Plot axis labels on an existing map.
}
\details{
This function is still in development, and the argument list as well as the
action taken are both subject to change, hence the brevity of this help page.

Note that if a grid line crosses the axis twice, only one label will be drawn.
}
\examples{
\donttest{
library(oce)
data(coastlineWorld)
par(mar=c(2, 2, 3, 1))
lonlim <- c(-180, 180)
latlim <- c(60, 120)
mapPlot(coastlineWorld, projection="+proj=stere +lat_0=90",
        longitudelim=lonlim, latitudelim=latlim,
        grid=FALSE)
mapGrid(15, 15, polarCircle=1/2)
mapAxis()
}

}
\seealso{
A map must first have been created with \code{\link[=mapPlot]{mapPlot()}}.

Other functions related to maps: 
\code{\link{formatPosition}()},
\code{\link{lonlat2map}()},
\code{\link{lonlat2utm}()},
\code{\link{map2lonlat}()},
\code{\link{mapArrows}()},
\code{\link{mapContour}()},
\code{\link{mapCoordinateSystem}()},
\code{\link{mapDirectionField}()},
\code{\link{mapGrid}()},
\code{\link{mapImage}()},
\code{\link{mapLines}()},
\code{\link{mapLocator}()},
\code{\link{mapLongitudeLatitudeXY}()},
\code{\link{mapPlot}()},
\code{\link{mapPoints}()},
\code{\link{mapPolygon}()},
\code{\link{mapScalebar}()},
\code{\link{mapText}()},
\code{\link{mapTissot}()},
\code{\link{oceCRS}()},
\code{\link{shiftLongitude}()},
\code{\link{usrLonLat}()},
\code{\link{utm2lonlat}()}
}
\author{
Dan Kelley
}
\concept{functions related to maps}
