% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBIENpoints.R
\name{getBIENpoints}
\alias{getBIENpoints}
\title{Download occurrence points from BIEN}
\usage{
getBIENpoints(taxon)
}
\arguments{
\item{taxon}{A single plant species or vector of plant species}
}
\value{
A list containing \enumerate{ \item a data frame of occurrence data;
\item a list containing: i notes on usage, ii bibtex citations,
and iii acknowledgment information; \item a data frame containing
the raw results of a query to \code{BIEN::BIEN_occurrence_species()}.}
}
\description{
Downloads occurrence points and useful related
information for processing within other occCite functions
}
\details{
\code{getBIENpoints} only returns all BIEN records, including non-
native and cultivated occurrences.
}
\examples{
\dontrun{
getBIENpoints(taxon = "Protea cynaroides")
}

}
