% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_audio.R
\name{audio_speech_request}
\alias{audio_speech_request}
\title{API audio: text to speech request}
\usage{
audio_speech_request(
  api_key,
  model,
  input,
  voice,
  response_format = NULL,
  speed = NULL
)
}
\arguments{
\item{api_key}{string, OpenAI API key
(see https://platform.openai.com/account/api-keys)}

\item{model}{string, one of the available TTS models: 'tts-1' or 'tts-1-hd'}

\item{input}{string, the text to generate audio for.
The maximum length is 4096 characters.}

\item{voice}{string, the voice to use when generating the audio. Supported
voices are alloy, echo, fable, onyx, nova, and shimmer.
Previews of the voices are available in the Text to speech guide -
https://platform.openai.com/docs/guides/text-to-speech/voice-options}

\item{response_format}{string, the format to audio in. Supported formats are
mp3 (default), opus, aac, and flac}

\item{speed}{double, the speed of the generated audio. Select a value from
0.25 to 4.0, 1.0 is the default.}
}
\value{
\link[httr]{content} of the httr \link[httr]{response} object
or SimpleError (\link[base]{conditions}) enhanced with
two additional fields: `status_code` (response$status_code)
and `message_long` (built on response content)
}
\description{
Generates audio from the input text. To get more details, visit
https://platform.openai.com/docs/api-reference/audio/createSpeech
https://platform.openai.com/docs/guides/speech-to-text
}
\examples{
\dontrun{
res_content <- audio_speech_request(
  "my-secret-api-key-string",
  "tts-1",
  "When the power of love overcomes the love of power, the world will know peace.",
  "nova"
)
if (!is_error(res_content)) {
  writeBin(res_content, "peace.mp3")
}
}

}
