% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nzilbb.labbcat.R
\name{getMediaTracks}
\alias{getMediaTracks}
\title{List the predefined media tracks available for transcripts.}
\usage{
getMediaTracks(labbcat.url)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}
}
\value{
A list of media track definitions.
}
\description{
List the predefined media tracks available for transcripts.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## specify the username/password in the script
## (only use labbcatCredentials for scripts that must execute unsupervised!)
labbcatCredentials(labbcat.url, "demo", "demo")

## Get the media tracks configured in LaBB-CAT
tracks <- getMediaTracks(labbcat.url)
}

}
\keyword{media}
\keyword{sound}
