#
# Copyright (c) 2005-2006, Scientific Computing Associates, Inc.
#
# NetWorkSpaces is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as published
# by the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
# USA
#

sshcmd <- function(host, options) {
  basicArgs <- c('ssh', '-f', '-x', '-l', options$user, host)

  wrapper <- file.path(options$wrapperDir, options$workerWrapper)
  if (file.access(wrapper) == 0) {
    if (identical(grep('\\.py$', wrapper, ignore.case=TRUE), as.integer(1))) {
      if (!is.null(options$python))
        c(options$python, wrapper, basicArgs)
      else
        c('python', wrapper, basicArgs)
    }
    else {
      c(wrapper, basicArgs)
    }
  }
  else {
    basicArgs
  }
}

rshcmd <- function(host, options) {
  basicArgs <- c('rsh', host, '-l', options$user, '-n')

  wrapper <- file.path(options$wrapperDir, 'BackgroundLaunch.py')
  if (!is.null(options$python))
    c(options$python, wrapper, basicArgs)
  else
    c('python', wrapper, basicArgs)
}

lsfcmd <- function(host, options) {
  'bsub'
}

envcmd <- function(host, envVars, options) {
  c('env', envVars, file.path(options$scriptDir, options$scriptName))
}

scriptcmd <- function(host, envVars, options) {
  if (!is.null(options$python))
    c(options$python, file.path(options$scriptDir, options$scriptName), envVars)
  else
    c('python', file.path(options$scriptDir, options$scriptName), envVars)
}
