% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nse.R
\name{nse.spec0}
\alias{nse.spec0}
\title{Spectral density at zero estimator}
\usage{
nse.spec0(x, type = c("ar", "glm", "wosa", "bartlett", "tukey"),
  lag.prewhite = 0)
}
\arguments{
\item{x}{A numeric vector.}

\item{type}{Method to use in estimating the spectral density function, among \code{"ar"}, \code{"glm"}, \code{"wosa"}, \code{"tukey"} and \code{"bartlett"}. See *Details*. 
Default is \code{type = "ar"}.}

\item{lag.prewhite}{Prewhite the series before analysis (integer or \code{NULL}). When \code{lag.prewhite = NULL} this performs automatic lag selection. Default is \code{lag.prewhite = 0} that is no prewhitening.}
}
\value{
The NSE estimator.
}
\description{
Function which calculates the numerical standard error with the spectrum at zero estimator.
}
\details{
The method \code{"ar"} estimates the spectral density using an autoregressive model, \code{"glm"} using a generelized linear model, \code{"wosa"} using the Welch's Overlapped Segment averaging nonparametric approach, \code{"tukey"} using Tukey-Hanning window and \code{"bartlett"} using the Bartlett window.
}
\note{
\code{nse.spec0} relies on the packages \code{coda}, \code{mcmcse} and \code{sapa}; see the documentation of these packages for more details.
}
\examples{
n    = 1000
ar   = 0.9
mean = 1
sd   = 1
set.seed(1234)   
x = as.vector(arima.sim(n = n, list(ar = ar), sd = sd) + mean)
 
nse.spec0(x = x, type = "ar", lag.prewhite = 0)
nse.spec0(x = x, type = "ar", lag.prewhite = 1)
nse.spec0(x = x, type = "ar", lag.prewhite = NULL)

nse.spec0(x = x, type = "glm", lag.prewhite = 0)
nse.spec0(x = x, type = "glm", lag.prewhite = 1)
nse.spec0(x = x, type = "glm", lag.prewhite = NULL)

nse.spec0(x = x, type = "wosa", lag.prewhite = 0)
nse.spec0(x = x, type = "wosa", lag.prewhite = 1)
nse.spec0(x = x, type = "wosa", lag.prewhite = NULL)

nse.spec0(x = x, type = "bartlett", lag.prewhite = 0)
nse.spec0(x = x, type = "bartlett", lag.prewhite = 1)
nse.spec0(x = x, type = "bartlett", lag.prewhite = NULL)

nse.spec0(x = x, type = "tukey", lag.prewhite = 0)
nse.spec0(x = x, type = "tukey", lag.prewhite = 1)
nse.spec0(x = x, type = "tukey", lag.prewhite = NULL)
}
\author{
David Ardia and Keven Bluteau
}
\references{
Flegal, J.M., Hughes, J., Vats D. (2010). 
Batch means and spectral variance estimators in Markov chain Monte Carlo.
\emph{Annals of Statistics} \bold{38}(2), pp.1034--1070. 
\doi{10.1214/09-aos735}
}

