% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createPedTree.R
\name{createPedTree}
\alias{createPedTree}
\title{Create a pedigree tree (PedTree).}
\usage{
createPedTree(ped)
}
\arguments{
\item{ped}{dataframe of pedigree and demographic information potentially
containing columns indicating the birth and death dates of an individual.
The table may also contain dates of sale (departure). Optional columns
are \code{birth}, \code{death}, \code{departure}.}
}
\value{
A list of named lists forming a pedigree tree (PedTree or ptree).
Each sublist represents an ID in the pedigree and contains the sire ID and
the dam ID as named elements.
}
\description{
The PedTree is a list containing sire and dam information for an individual.
}
\details{
Part of Pedigree Sampling
From PedigreeSampling.R
2016-01-28

Contains functions to build pedigrees from sub-samples
of genotyped individuals.

The goal of sampling is to reduce the number of inbreeding
loops in the resulting pedigree, and thus, reduce the
amount of time required to perform calculations with
SIMWALK2 or similar programs.

This function uses only \code{id}, \code{sire}, and \code{dam} columns.
}
\examples{
library(nprcgenekeepr)
exampleTree <- createPedTree(nprcgenekeepr::examplePedigree)
exampleLoops <- findLoops(exampleTree)
}
