% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.R
\name{tweak.model}
\alias{tweak.model}
\title{Tweak Model}
\usage{
\method{tweak}{model}(x, sd = 0.13, digits = 3, ...)
}
\arguments{
\item{x}{object}

\item{sd}{numeric}

\item{digits}{integer}

\item{...}{dots}
}
\value{
model
}
\description{
Tweaks model.
}
\examples{
# Create a working project.
source <- system.file(package = 'nonmemica','project')
target <- tempdir()
target <- gsub('\\\\\\\\','/',target) # for windows
source
target
file.copy(source,target,recursive = TRUE)
project <- file.path(target,'project','model')

# Point project option at working project
options(project = project)
library(magrittr)

# Make ten new models with slightly different initial estimates.
1001 \%>\% tweak
}
\seealso{
Other tweak: \code{\link{tweak.default}},
  \code{\link{tweak.inits}}, \code{\link{tweak.init}},
  \code{\link{tweak}}
}
