% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_integration.R
\name{db_copy_to}
\alias{db_copy_to}
\alias{db_copy_to.AthenaConnection}
\title{S3 implementation of \code{db_copy_to} for Athena}
\usage{
db_copy_to.AthenaConnection(con, table, values, overwrite = FALSE,
  append = FALSE, types = NULL, partition = NULL,
  s3_location = NULL, file_type = c("csv", "tsv", "parquet"), ...)
}
\arguments{
\item{con}{A \code{\link{dbConnect}} object, as returned by \code{dbConnect()}}

\item{table}{A character string specifying a table name. Names will be
automatically quoted so you can use any sequence of characters, not
just any valid bare table name.}

\item{values}{A data.frame to write to the database.}

\item{overwrite}{Allow overwriting the destination table. Cannot be
`TRUE` if `append` is also `TRUE`.}

\item{append}{Allow appending to the destination table. Cannot be
`TRUE` if `overwrite` is also `TRUE`.}

\item{types}{Additional field types used to override derived types.}

\item{partition}{Partition Athena table (needs to be a named list or vector) for example: \code{c(var1 = "2019-20-13")}}

\item{s3_location}{s3 bucket to store Athena table, must be set as a s3 uri for example ("s3://mybucket/data/")}

\item{file_type}{What file type to store data.frame on s3, noctua currently supports ["csv", "tsv", "parquet"]. 
\strong{Note:} "parquet" format is supported by the \code{arrow} package and it will need to be installed to utilise the "parquet" format.}

\item{...}{other parameters currently not supported in noctua}
}
\value{
db_copy_to returns table name
}
\description{
This is an Athena method for dbplyr function \code{db_copy_to} to create an Athena table from a \code{data.frame}.
}
\examples{
\dontrun{
# Note: 
# - Require AWS Account to run below example.
# - Different connection methods can be used please see `noctua::dbConnect` documnentation

library(DBI)
library(dplyr)

# Demo connection to Athena using profile name 
con <- dbConnect(noctua::athena())

# List existing tables in Athena
dbListTables(con)

# Write data.frame to Athena table
copy_to(con, mtcars,
        s3_location = "s3://mybucket/data/")
             
# Checking if uploaded table exists in Athena
dbExistsTable(con, "mtcars")

# Write Athena table from tbl_sql
athena_mtcars <- tbl(con, "mtcars")
mtcars_filter <- athena_mtcars \%>\% filter(gear >=4)

copy_to(con, mtcars_filter)

# Checking if uploaded table exists in Athena
dbExistsTable(con, "mtcars_filter") 

# Disconnect from Athena
dbDisconnect(con)
}
}
\seealso{
\code{\link{AthenaWriteTables}}
}
