#
# 3-order tensor
#
X <- toyModel("CP")

out1_1 <- NTF(X, rank=3, algorithm="Frobenius", num.iter=2)
out1_2 <- NTF(X, rank=3, algorithm="Frobenius", init="ALS", num.iter=2)
out1_3 <- NTF(X, rank=3, algorithm="Frobenius", init="Random", num.iter=2)
out2 <- NTF(X, rank=3, algorithm="KL", num.iter=2)
out3 <- NTF(X, rank=3, algorithm="IS", num.iter=2)
out4 <- NTF(X, rank=3, algorithm="Pearson", num.iter=2)
out5 <- NTF(X, rank=3, algorithm="Hellinger", num.iter=2)
out6 <- NTF(X, rank=3, algorithm="Neyman", num.iter=2)
out7 <- NTF(X, rank=3, algorithm="Alpha", num.iter=2)
out8 <- NTF(X, rank=3, algorithm="Beta", num.iter=2)
out9 <- NTF(X, rank=3, algorithm="HALS", num.iter=2)
out10 <- NTF(X, rank=3, algorithm="Alpha-HALS", num.iter=2)
out11 <- NTF(X, rank=3, algorithm="Beta-HALS", num.iter=2)

expect_equivalent(length(out1_1), 6)
expect_equivalent(length(out1_2), 6)
expect_equivalent(length(out1_3), 6)
expect_equivalent(length(out2), 6)
expect_equivalent(length(out3), 6)
expect_equivalent(length(out4), 6)
expect_equivalent(length(out5), 6)
expect_equivalent(length(out6), 6)
expect_equivalent(length(out7), 6)
expect_equivalent(length(out8), 6)
expect_equivalent(length(out9), 6)
expect_equivalent(length(out10), 6)
expect_equivalent(length(out11), 6)

#
# 4-order tensor
#
# library("rTensor")
# XX <- array(0, dim=c(30,30,30,4))
# XX[,,,1] <- X@data
# XX[,,,2] <- X@data * runif(length(X@data))
# XX[,,,3] <- X@data * 1.2 * runif(length(X@data))
# XX[,,,4] <- X@data * 3 * runif(length(X@data))
# XX <- as.tensor(XX)

# out_NTF4_1_1 <- NTF(XX, rank=3, algorithm="Frobenius", num.iter=2)
# out_NTF4_1_2 <- NTF(XX, rank=3, algorithm="Frobenius", init="ALS", num.iter=2)
# out_NTF4_1_3 <- NTF(XX, rank=3, algorithm="Frobenius", init="Random", num.iter=2)
# out_NTF4_2 <- NTF(XX, rank=3, algorithm="KL", num.iter=2)
# out_NTF4_3 <- NTF(XX, rank=3, algorithm="IS", num.iter=2)
# out_NTF4_4 <- NTF(XX, rank=3, algorithm="Pearson", num.iter=2)
# out_NTF4_5 <- NTF(XX, rank=3, algorithm="Hellinger", num.iter=2)
# out_NTF4_6 <- NTF(XX, rank=3, algorithm="Neyman", num.iter=2)
# out_NTF4_7 <- NTF(XX, rank=3, algorithm="Alpha", num.iter=2)
# out_NTF4_8 <- NTF(XX, rank=3, algorithm="Beta", num.iter=2)
# out_NTF4_9 <- NTF(XX, rank=3, algorithm="HALS", num.iter=2)
# out_NTF4_10 <- NTF(XX, rank=3, algorithm="Alpha-HALS", num.iter=2)
# out_NTF4_11 <- NTF(XX, rank=3, algorithm="Beta-HALS", num.iter=2)

# expect_equivalent(length(out_NTF4_1_1), 6)
# expect_equivalent(length(out_NTF4_1_2), 6)
# expect_equivalent(length(out_NTF4_1_3), 6)
# expect_equivalent(length(out_NTF4_2), 6)
# expect_equivalent(length(out_NTF4_3), 6)
# expect_equivalent(length(out_NTF4_4), 6)
# expect_equivalent(length(out_NTF4_5), 6)
# expect_equivalent(length(out_NTF4_6), 6)
# expect_equivalent(length(out_NTF4_7), 6)
# expect_equivalent(length(out_NTF4_8), 6)
# expect_equivalent(length(out_NTF4_9), 6)
# expect_equivalent(length(out_NTF4_10), 6)
# expect_equivalent(length(out_NTF4_11), 6)
