% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze_nl.R
\name{analyze_nl}
\alias{analyze_nl}
\title{Analyze NetLogo simulation output}
\usage{
analyze_nl(nl, metrics = getexp(nl, "metrics"), funs = list(mean =
  mean))
}
\arguments{
\item{nl}{nl object}

\item{metrics}{vector of strings defining metric columns for evaluation. Defaults to metrics of the experiment within the nl object}

\item{funs}{list with the summary metrics for the sensitivity results}
}
\value{
analysis summary tibble
}
\description{
Analyze NetLogo simulation output
}
\details{
The analyze_nl function runs basic analyses on NetLogo simulation output.
In order to execute this function, simulation output needs to be attached to the simdesign first with \code{setsim(nl, "output") <- results}.

analyze_nl calls different post-processing analysis functions, depending on the specified method in the simdesign object of the nl object.

\strong{The following simdesign are currently supported:}

\link[nlrx]{simdesign_ff}

Calls \link[nlrx]{analyze_ff}.
The function calculates aggregated output metrics by dropping random seeds and aggregating values with the provided functions.

\link[nlrx]{simdesign_lhs}

Calls \link[nlrx]{analyze_lhs}.
The function calculates aggregated output metrics by dropping random seeds and aggregating values with the provided functions.

\link[nlrx]{simdesign_sobol}

Calls \link[nlrx]{analyze_sobol}.
The function calculates sobol sensitivity indices from the output results using the \link[sensitivity]{sensitivity} package.

\link[nlrx]{simdesign_sobol2007}

Calls \link[nlrx]{analyze_sobol2007}.
The function calculates sobol sensitivity indices from the output results using the \link[sensitivity]{sensitivity} package.

\link[nlrx]{simdesign_soboljansen}

Calls \link[nlrx]{analyze_soboljansen}.
The function calculates sobol sensitivity indices from the output results using the \link[sensitivity]{sensitivity} package.

\link[nlrx]{simdesign_morris}

Calls \link[nlrx]{analyze_morris}.
The function calculates morris sensitivity indices from the output results using the \link[sensitivity]{sensitivity} package.

\link[nlrx]{simdesign_eFast}

Calls \link[nlrx]{analyze_eFast}.
The function calculates eFast sensitivity indices from the output results using the \link[sensitivity]{sensitivity} package.

\strong{For the following simdesign no postprocessing analysis function has been implemented yet:}

\link[nlrx]{simdesign_simple},
\link[nlrx]{simdesign_distinct},
\link[nlrx]{simdesign_GenSA},
\link[nlrx]{simdesign_GenAlg}
}
\examples{

# Load nl object including output data from testdata
nl <- nl_sobol

# Define aggregation measurements:
myfuns <- list(mean=mean, sd=sd, min=min, max=max)

# Calculate sensitivity indices:
analyze_nl(nl, funs = myfuns)

}
