% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_nlme.R
\name{boot_nlme}
\alias{boot_nlme}
\alias{boot_gnls}
\title{Bootstraping for generalized nonlinear models and nonlinear mixed models}
\usage{
boot_nlme(object, f = NULL, R = 999, psim = 1, cores = 1L, data = NULL, ...)

boot_gnls(object, f = NULL, R = 999, psim = 1, cores = 1L, data = NULL, ...)
}
\arguments{
\item{object}{object of class \code{\link[nlme]{nlme}} or \code{\link[nlme]{gnls}}}

\item{f}{function to be applied (and bootstrapped), default coef (gnls) or fixef (nlme)}

\item{R}{number of bootstrap samples, default 999}

\item{psim}{simulation level for vector of fixed parameters either for \code{\link{simulate_gnls}} or \code{\link{simulate_nlme_one}}}

\item{cores}{number of cores to use for parallel computation}

\item{data}{optional data argument (useful/needed when data are not in an available environment).}

\item{...}{additional arguments to be passed to function \code{\link[boot]{boot}}}
}
\description{
Bootstraping tools for nonlinear models using a consistent interface

bootstrap function for objects of class \code{\link[nlme]{gnls}}
}
\details{
This function is inspired by \code{\link[car]{Boot}}, which does not
seem to work with 'gnls' or 'nlme' objects. This function makes multiple copies 
of the original data, so it can be very hungry in terms of memory use, but
I do not believe this to be a big problem given the models we typically fit.
}
\examples{
\donttest{
require(car)
require(nlme)
data(barley, package = "nlraa")
barley2 <- subset(barley, year < 1974)
fit.lp.gnls2 <- gnls(yield ~ SSlinp(NF, a, b, xs), data = barley2)
barley2$year.f <- as.factor(barley2$year)
cfs <- coef(fit.lp.gnls2)
fit.lp.gnls3 <- update(fit.lp.gnls2, 
                      params = list(a + b + xs ~ year.f),
                      start = c(cfs[1], 0, 0, 0, 
                                cfs[2], 0, 0, 0,
                                cfs[3], 0, 0, 0))
## This will take a few seconds                               
fit.lp.gnls.Bt3 <- boot_nlme(fit.lp.gnls3, R = 300) 
confint(fit.lp.gnls.Bt3, type = "perc")
}

}
