% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UNI.loading_helper.R
\name{getUNI.loadings}
\alias{getUNI.loadings}
\title{Get Factor Loadings for a Univariate Longitudinal Outcome with Specified Functional Curves}
\usage{
getUNI.loadings(y_model, t_var, y_var, curveFun, intrinsic, records)
}
\arguments{
\item{y_model}{A string specifying how to fit the longitudinal outcome. Supported values are \code{"LGCM"} and
\code{"LCSM"}. It is \code{"LGCM"} or \code{"LCSM"}, or takes the value passed from \code{getTVCmodel()}.}

\item{t_var}{A string specifying the prefix of the column names corresponding to the time variable at each study wave.
It takes the value passed from \code{getLGCM()} or \code{getLCSM()} or \code{getTVCmodel()}.}

\item{y_var}{A string specifying the prefix of the column names corresponding to the outcome variable at each study wave.
It takes the value passed from \code{getLGCM()} or \code{getLCSM()} or \code{getTVCmodel()}.}

\item{curveFun}{A string specifying the functional form of the growth curve. Supported options for \code{y_model =
"LGCM"} include: \code{"linear"} (or \code{"LIN"}), \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"bilinear spline"} (or \code{"BLS"}). Supported
options for \code{y_model = "LCSM"} include: \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"nonparametric"} (or \code{"NonP"}). It takes the
value passed from \code{getLGCM()} or \code{getLCSM()} or \code{getTVCmodel()}.}

\item{intrinsic}{A logical flag indicating whether to build an intrinsically nonlinear longitudinal model. It takes the
value passed from \code{getLGCM()} or \code{getLCSM()} or \code{getTVCmodel()}.}

\item{records}{A numeric vector specifying indices of the study waves. It takes the value passed from \code{getLGCM()} or
\code{getLCSM()} or \code{getTVCmodel()}.}
}
\value{
A list containing the specification of definition variables (i.e., individual time points for the latent
growth curve models, and individual time points and individual time lags (intervals) between adjacent time points
for latent change score models) and factor loadings of a univariate longitudinal outcome.
}
\description{
This function specifies the factor loadings for a univariate longitudinal outcome with given functional
form. The longitudinal outcome is fit by a Latent Growth Curve Model or a Latent Change Score Model.
}
