% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_theo_md.R
\docType{data}
\name{theo_md}
\alias{theo_md}
\title{Multiple dose theophylline PK data}
\format{
A data frame with 348 rows by 7 columns

\describe{
\item{ID}{Subject ID}
\item{TIME}{Time (hr)}
\item{DV}{Dependent Variable, theophylline concentration (mg/L)}
\item{AMT}{Dose Amount (kg)}
\item{EVID}{rxode2/nlmixr2 event ID (not NONMEM event IDs)}
\item{CMT}{Compartment number}
\item{WT}{Body weight (kg)}
}
}
\source{
NONMEM/nlme
}
\usage{
theo_md
}
\description{
This data set starts with the day 1 concentrations of the
theophylline data that is included in the nlme/NONMEM. After day 7
concentrations were simulated with once a day regimen for 7 days
(QD).
}
\seealso{
Other nlmixr2 datasets: 
\code{\link{Bolus_1CPTMM}},
\code{\link{Bolus_1CPT}},
\code{\link{Bolus_2CPTMM}},
\code{\link{Bolus_2CPT}},
\code{\link{Infusion_1CPTMM}},
\code{\link{Infusion_1CPT}},
\code{\link{Infusion_2CPTMM}},
\code{\link{Infusion_2CPT}},
\code{\link{Oral_1CPTMM}},
\code{\link{Oral_1CPT}},
\code{\link{Oral_2CPTMM}},
\code{\link{Oral_2CPT}},
\code{\link{Wang2007}},
\code{\link{mavoglurant}},
\code{\link{nimoData}},
\code{\link{nmtest}},
\code{\link{pheno_sd}},
\code{\link{rats}},
\code{\link{theo_sd}},
\code{\link{warfarin}},
\code{\link{wbcSim}}
}
\concept{nlmixr2 datasets}
\keyword{datasets}
