% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmtest.R
\docType{data}
\name{nmtest}
\alias{nmtest}
\title{One compartment test dataset showing NONMEM 7.4.3 output}
\format{
A data frame with 7,157 rows and 15 columns

\describe{
\item{id}{NONMEM id}
\item{time}{NONMEM time}
\item{cp}{NONMEM cp output from 7.4.3}
\item{cmt}{cmt specification 1=depot, 2=central}
\item{amt}{Nonmem dose}
\item{evid}{NONMEM Event ID}
\item{ii}{Interdose Interval}
\item{ss}{Steady state flag}
\item{addl}{Individual Clearance}
\item{rate}{Rate of the infusion}
\item{lagt}{Lag time}
\item{bioav}{Bioavailability}
\item{rat2}{Modeled rate when \code{mode} == 1}
\item{dur2}{Duration when \code{mode} == 2}
\item{mode}{Mode = 0 is no modification, modeled rate when mode=1 and modeled duration when mode=2}
}
}
\usage{
nmtest
}
\description{
This is a example dataset originally created to show how similar
\code{mrgsolve} and NONMEM were (See ).
}
\details{
The original dataset was created by Kyle Baron and is composed of
\code{id<100} the \code{id>100} are modifications by Matthew Fidler to
benchmark steady state infusions with lag times and other uncommon
features.

Note that \code{rxode2}/\code{nlmixr2} will not always match these behaviors
by default, we choose behaviors that we believe make sense.  There
are options to make \code{rxode2}/\code{nlmixr2} behave more like NONMEM.
However behaviors we believe are wrong we do not support.
}
\seealso{
Other nlmixr2 datasets: 
\code{\link{Bolus_1CPTMM}},
\code{\link{Bolus_1CPT}},
\code{\link{Bolus_2CPTMM}},
\code{\link{Bolus_2CPT}},
\code{\link{Infusion_1CPTMM}},
\code{\link{Infusion_1CPT}},
\code{\link{Infusion_2CPTMM}},
\code{\link{Infusion_2CPT}},
\code{\link{Oral_1CPTMM}},
\code{\link{Oral_1CPT}},
\code{\link{Oral_2CPTMM}},
\code{\link{Oral_2CPT}},
\code{\link{Wang2007}},
\code{\link{mavoglurant}},
\code{\link{nimoData}},
\code{\link{pheno_sd}},
\code{\link{rats}},
\code{\link{theo_md}},
\code{\link{theo_sd}},
\code{\link{warfarin}},
\code{\link{wbcSim}}
}
\author{
Kyle Baron & Matthew Fidler
}
\concept{nlmixr2 datasets}
\keyword{datasets}
