% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resid.R
\name{tableControl}
\alias{tableControl}
\title{Output table/data.frame options}
\usage{
tableControl(
  npde = NULL,
  cwres = NULL,
  nsim = 300,
  ties = TRUE,
  censMethod = c("truncated-normal", "cdf", "ipred", "pred", "epred", "omit"),
  seed = 1009,
  cholSEtol = (.Machine$double.eps)^(1/3),
  state = TRUE,
  lhs = TRUE,
  eta = TRUE,
  covariates = TRUE,
  addDosing = FALSE,
  subsetNonmem = TRUE,
  cores = NULL
)
}
\arguments{
\item{npde}{When TRUE, request npde regardless of the algorithm used.}

\item{cwres}{When TRUE, request CWRES and FOCEi likelihood
regardless of the algorithm used.}

\item{nsim}{represents the number of simulations.  For RxODE, if
you supply single subject event tables (created with
\verb{[eventTable()]})}

\item{ties}{When `TRUE` jitter prediction-discrepancy points to discourage ties in cdf.}

\item{censMethod}{Handle censoring method:

 - `"truncated-normal"` Simulates from a truncated normal distribution under the assumption of the model and censoring.

 - `"cdf"` Use the cdf-method for censoring with npde and use this for any other residuals (`cwres` etc)

 - `"omit"` omit the residuals for censoring}

\item{seed}{an object specifying if and how the random number
generator should be initialized}

\item{cholSEtol}{The tolerance for the `RxODE::choleSE` function}

\item{state}{is a Boolean indicating if `state` values will be included (default `TRUE`)}

\item{lhs}{is a Boolean indicating if remaining `lhs` values will be included (default `TRUE`)}

\item{eta}{is a Boolean indicating if `eta` values will be included (default `TRUE`)}

\item{covariates}{is a Boolean indicating if covariates will be included (default `TRUE`)}

\item{addDosing}{Boolean indicating if the solve should add RxODE
EVID and related columns.  This will also include dosing
information and estimates at the doses.  Be default, RxODE
only includes estimates at the observations. (default
\code{FALSE}). When \code{addDosing} is \code{NULL}, only
include \code{EVID=0} on solve and exclude any model-times or
\code{EVID=2}. If \code{addDosing} is \code{NA} the classic
\code{RxODE} EVID events are returned. When \code{addDosing} is \code{TRUE}
add the event information in NONMEM-style format; If
\code{subsetNonmem=FALSE} RxODE will also include extra event types
(\code{EVID}) for ending infusion and modeled times:
\itemize{
\item \code{EVID=-1} when the modeled rate infusions are turned
off (matches \code{rate=-1})
\item \code{EVID=-2} When the modeled duration infusions are
turned off (matches \code{rate=-2})
\item \code{EVID=-10} When the specified \code{rate} infusions are
turned off (matches \code{rate>0})
\item \code{EVID=-20} When the specified \code{dur} infusions are
turned off (matches \code{dur>0})
\item \verb{EVID=101,102,103,...} Modeled time where 101 is the
first model time, 102 is the second etc.
}}

\item{subsetNonmem}{subset to NONMEM compatible EVIDs only.  By
default \code{TRUE}.}

\item{cores}{Number of cores used in parallel ODE solving.  This
is equivalent to calling \code{\link[RxODE:getRxThreads]{setRxThreads()}}}
}
\value{
A list of table options for nlmixr
}
\description{
Output table/data.frame options
}
\details{
If you ever want to add CWRES/FOCEi objective function you can use the \code{\link{addCwres}}

If you ever want to add NPDE/EPRED columns you can use the \code{\link{addNpde}}
}
\author{
Matthew L. Fidler
}
