% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in Rtmp9wH6ZH/file2ef7725fe91c
\name{nimMatrix}
\alias{matrix}
\alias{nimMatrix}
\title{Creates a matrix object for use in NIMBLE DSL functions}
\usage{
nimMatrix(value = 0, nrow = 1, ncol = 1, init = TRUE, type = "double")
}
\arguments{
\item{value}{the initial value for each element of the matrix (default = 0)}

\item{nrow}{the number of rows in the matrix (default = 1)}

\item{ncol}{the number of columns in the matrix (default = 1)}

\item{init}{logical, whether to initialize elements of the matrix (default = TRUE)}

\item{type}{character representing the data type, i.e. 'double' or 'integer' (default = 'double')}
}
\description{
In a \code{nimbleFunction}, \code{matrix} is identical to \code{nimMatrix}
}
\details{
See the User Manual for usage examples.

When used in a \code{nimbleFunction} (in \code{run} or other member function), \code{matrix} is a synonym for \code{nimMatrix}.  When used with only the first three arguments, this behaves similarly to R's \code{matrix} function.  NIMBLE provides additional arguments to control the initialization value, whether or not initialization will occur, and the type of scalar elements.  Using \code{init=FALSE} when initialization is not necessary can make compiled nimbleFunctions a bit faster.
}
\author{
Daniel Turek
}
\seealso{
\code{\link{numeric}} \code{\link{integer}} \code{\link{array}}
}

