% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nldi.R
\name{get_nldi_index}
\alias{get_nldi_index}
\title{Get NLDI Index}
\usage{
get_nldi_index(location)
}
\arguments{
\item{location}{numeric WGS84 lon/lat pair (X, Y)}
}
\description{
uses the Network Linked Data Index to retrieve and estimated
network location for the given point. If not within a grid cell of a flowline,
will use a raindrop trace service to find the nearest downslope flowline
location.
}
\examples{
\donttest{
index <- get_nldi_index(c(-89.276, 42.988))

plot_nhdplus(bbox = sf::st_bbox(sf::st_buffer(index[1,], units::set_units(1000, "m"))))
plot(sf::st_geometry(sf::st_transform(index, 3857)), add = TRUE)
}
}
