% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/nhanes.R
\name{nhanesTables}
\alias{nhanesTables}
\title{Returns a list of table names for the specified survey group}
\usage{
nhanesTables(nh_surveygroup, year, details = FALSE)
}
\arguments{
\item{nh_surveygroup}{The type of survey (DEMOGRAPHIC, DIETARY, EXAMINATION, LABORATORY, QUESTIONNAIRE)}

\item{year}{The year in yyyy format where 1999 <= yyyy <= 2012}

\item{details}{If true then a more detailed description of the tables is returned}
}
\value{
The names of the tables in the specified survey group
}
\description{
Returns a list of table names for the specified survey group
}
\details{
The first step in browsing NHANES data is to display the table names.
The table names are stored internal to the nhanes package, i.e. the information is retrieved from
internal tables such as vars_EXAMINATION_2005-2006.
}
\examples{
nhanesTables('EXAM', 2007)
nhanesTables('LAB', 2009, details=TRUE)
}

