% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_player_stats.R
\name{load_player_stats}
\alias{load_player_stats}
\title{Load Player Level Weekly Stats}
\usage{
load_player_stats(
  seasons = most_recent_season(),
  stat_type = c("offense", "defense", "kicking"),
  file_type = getOption("nflreadr.prefer", default = "rds")
)
}
\arguments{
\item{seasons}{a numeric vector of seasons to return, defaults to most recent season. If set to \code{TRUE}, returns all available data.}

\item{stat_type}{one of \code{"offense"}, \code{"defense"}, or \code{"kicking"}}

\item{file_type}{One of \code{c("rds", "qs", "csv", "parquet")}. Can also be set globally with
\code{options(nflreadr.prefer)}}
}
\value{
A tibble of week-level player statistics that aims to match NFL official box scores.
}
\description{
Load Player Level Weekly Stats
}
\examples{
\dontshow{.for_cran()}
\donttest{
try({ # prevents cran errors
  load_player_stats()
  load_player_stats(stat_type = "kicking")
})
}

}
\seealso{
\url{https://nflreadr.nflverse.com/articles/dictionary_player_stats.html} for a web version of the data dictionary

\code{\link{dictionary_player_stats}} for the data dictionary

Issues with this data should be filed here: \url{https://github.com/nflverse/nflverse-pbp}
}
