% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/split.R
\docType{methods}
\name{group_split}
\alias{group_split}
\alias{group_split-method}
\alias{split,CompositionMatrix-method}
\alias{split,LogRatio-method}
\alias{group_split,GroupedComposition-method}
\alias{group_split,GroupedLogRatio-method}
\title{Divide into Groups}
\usage{
group_split(object, ...)

\S4method{split}{CompositionMatrix}(x, f, drop = FALSE, ...)

\S4method{split}{LogRatio}(x, f, drop = FALSE, ...)

\S4method{group_split}{GroupedComposition}(object, ...)

\S4method{group_split}{GroupedLogRatio}(object, ...)
}
\arguments{
\item{object, x}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Currently not used.}

\item{f}{A \code{factor} in the sense that \code{\link[=as.factor]{as.factor(f)}} defines
the grouping, or a list of such factors in which case their interaction is
used for the grouping (see \code{\link[base:split]{base::split()}}).}

\item{drop}{A \code{\link{logical}} scalar: should levels that do not occur be dropped?}
}
\value{
A \code{list} of \code{\linkS4class{CompositionMatrix}} objects.
}
\description{
Divides a compositional matrix by groups.
}
\examples{
## Create a data.frame
X <- data.frame(
  samples = c("A", "A", "A", "B", "B", "B", "C", "C", "C"),
  groups = c("X", "X", "X", "X", NA, NA, "Y", "Y", "Y"),
  Ca = c(7.72, 7.32, 3.11, 7.19, 7.41, 5, 4.18, 1, 4.51),
  Fe = c(6.12, 5.88, 5.12, 6.18, 6.02, 7.14, 5.25, 5.28, 5.72),
  Na = c(0.97, 1.59, 1.25, 0.86, 0.76, 0.51, 0.75, 0.52, 0.56)
)

## Coerce to a compositional matrix
Y <- as_composition(X, parts = c("Ca", "Fe", "Na"))

## Split by group
## /!\ Unassigned samples (NA) are discarded ! /!\
(s1 <- split(Y, f = X$groups))

## Better to use grouped matrix
Y <- group(Y, by = X$groups)
(s2 <- group_split(Y))

## Bind by rows
do.call(rbind, s2)
}
\seealso{
Other grouping methods: 
\code{\link{group}()},
\code{\link{group_metadata}},
\code{\link{group_subset}()}
}
\author{
N. Frerebeau
}
\concept{grouping methods}
