% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/condense.R
\docType{methods}
\name{condense}
\alias{condense}
\alias{condense-method}
\alias{condense,CompositionMatrix-method}
\alias{condense,GroupedComposition-method}
\title{Compositional Mean of Data Subsets}
\usage{
condense(x, ...)

\S4method{condense}{CompositionMatrix}(x, by, ignore_na = FALSE, ignore_zero = TRUE, verbose = FALSE, ...)

\S4method{condense}{GroupedComposition}(
  x,
  by = NULL,
  ignore_na = FALSE,
  ignore_zero = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Currently not used.}

\item{by}{A \code{vector} or a list of grouping elements, each as long as the
variables in \code{x} (see \code{\link[=group]{group()}}).}

\item{ignore_na}{A \code{\link{logical}} scalar: should \link[=NA]{missing values} be
stripped before the computation proceeds?}

\item{ignore_zero}{A \code{\link{logical}} scalar: should zeros be stripped before the
computation proceeds?}

\item{verbose}{A \code{\link{logical}} scalar: should \R report extra information
on progress?}
}
\value{
A \code{\linkS4class{CompositionMatrix}} object.
}
\description{
Splits the data into subsets and computes compositional mean for each.
}
\examples{
## Data from Aitchison 1986
data("slides")

## Coerce to a compositional matrix
coda <- as_composition(slides, groups = 2)

## Compositional mean by group
condense(coda)
}
\seealso{
\code{\link[=mean]{mean()}}, \code{\link[=aggregate]{aggregate()}}

Other statistics: 
\code{\link{aggregate}()},
\code{\link{covariance}()},
\code{\link{dist}},
\code{\link{mahalanobis}()},
\code{\link{margin}()},
\code{\link{mean}()},
\code{\link{pip}()},
\code{\link{quantile}()},
\code{\link{scale}()},
\code{\link{variance}()},
\code{\link{variance_total}()},
\code{\link{variation}()}
}
\author{
N. Frerebeau
}
\concept{statistics}
