% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/simplex.R
\docType{methods}
\name{perturbation}
\alias{perturbation}
\alias{perturbation-method}
\alias{perturbation,numeric,numeric-method}
\alias{perturbation,CompositionMatrix,numeric-method}
\alias{perturbation,CompositionMatrix,matrix-method}
\alias{perturbation,CompositionMatrix,CompositionMatrix-method}
\title{Perturbation Operation}
\usage{
perturbation(x, y, ...)

\S4method{perturbation}{numeric,numeric}(x, y)

\S4method{perturbation}{CompositionMatrix,numeric}(x, y)

\S4method{perturbation}{CompositionMatrix,matrix}(x, y)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector of compositional data or a
\code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Currently not used.}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Perturbation of two compositions.
}
\details{
In compositional geometry, perturbation plays the role of sum (translation).
It is the closed component-wise product of two compositions.
}
\examples{
x <- as_composition(c(1, 2, 3))
y <- as_composition(c(1, 2, 1))

## Perturbation
perturbation(x, y)
x + y

## Powering
powering(y, 2)
y * 2

## Scalar product
scalar(x, y)
}
\seealso{
Other operations in the simplex: 
\code{\link{arithmetic}},
\code{\link{closure}()},
\code{\link{powering}()},
\code{\link{scalar}()}
}
\author{
N. Frerebeau
}
\concept{operations in the simplex}
