% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_headlines_all.R
\name{get_headlines_all}
\alias{get_headlines_all}
\title{Returns all headlines from newsapi.org}
\usage{
get_headlines_all(query = NULL, category = NULL, country = NULL,
  sources = NULL, api_key = Sys.getenv("NEWS_API_KEY"))
}
\arguments{
\item{query}{Character string that contains the searchterm}

\item{category}{Category you want headlines from}

\item{country}{Country you want headlines for}

\item{sources}{Character string with IDs (comma separated) of the news outlets 
you want to focus on (e.g., "usa-today, spiegel-online").}

\item{api_key}{Character string with the API key you get from newsapi.org. 
Passing it is compulsory. Alternatively, function can be 
provided from the global environment (see \code{set_api_key}).}
}
\value{
List with two dataframes:\cr
        1) Data frame with \code{results_df}\cr
        2) Data frame with \code{meta_data}
}
\description{
\code{get_headlines} returns live top and breaking headlines for a country, 
specific category in a country, single source, or multiple sources. You can 
also search with keywords. Articles are sorted by the earliest date 
published first. To automatically download all results, use 
\code{get_headlines_all}.\cr\cr
Please check that the api_key is available. You can provide an explicit
definition of the api_key or use \code{set_api_key} \cr\cr
Valid searchterms are provided in \code{terms_category}, 
\code{terms_country} or \code{terms_sources}
}
\examples{
\dontrun{
df <- get_headlines_all(query = "sports")
df <- get_headlines_all(category = "health")
}
}
