% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dld.R
\name{dld}
\alias{dld}
\alias{ddld}
\alias{pdld}
\alias{qdld}
\alias{rdld}
\title{The discrete Lindley distribution}
\usage{
ddld(x, theta, log = FALSE)

pdld(q, theta, lower.tail = TRUE, log.p = FALSE)

qdld(p, theta, lower.tail = TRUE)

rdld(n, theta)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{theta}{a parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P\left[ X\leq x\right]}, otherwise,\eqn{P\left[ X>x\right] }.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken
to be the number required.}
}
\value{
\code{ddld} gives the density, \code{pdld} gives the distribution
function, \code{qdld} gives the quantile function and \code{rdld} generates
random deviates.
}
\description{
Density, distribution function, quantile function and random generation for
the discrete Lindley distribution parameter.
}
\details{
The discrete Lindley distribution with a parameter \eqn{\theta}, has density
given by
\deqn{f\left( x\right) =\frac{\lambda ^{x}}{1-\log \lambda }
\left( \lambda \log\lambda +\left( 1-\lambda \right)
\left( 1-\log \lambda^{x+1}\right)\right), }
where
\deqn{x=0,1,...,~\theta >0,~\lambda =e^{-\theta }.}
}
\examples{
library(new.dist)
ddld(1,theta=2)
pdld(2,theta=1)
qdld(.993,theta=2)
rdld(10,theta=1)
}
\references{
Gómez-Déniz, E. ve Calderín-Ojeda, E., 2011,
\emph{The discrete Lindley distribution: properties and applications}.Journal of
statistical computation and simulation, 81 (11), 1405-1416.
}
