% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{inner-products}
\alias{inner-products}
\alias{ipro_frobenius}
\title{Inner-Products Between Networks}
\usage{
ipro_frobenius(x, y, representation = "laplacian")
}
\arguments{
\item{x}{An \code{\link[igraph]{igraph}} object or a matrix representing an
underlying network.}

\item{y}{An \code{\link[igraph]{igraph}} object or a matrix representing an
underlying network. Should have the same number of vertices as \code{x}.}

\item{representation}{A string specifying the desired type of representation,
among: \code{"adjacency"}, \code{"laplacian"}, \code{"modularity"} or
\code{"graphon"}. Default is \code{"laplacian"}.}
}
\value{
A scalar measuring the angle between the two input networks.
}
\description{
This is a collection of functions computing the inner product between two
networks.
}
\examples{
g1 <- igraph::sample_gnp(20, 0.1)
g2 <- igraph::sample_gnp(20, 0.2)
ipro_frobenius(g1, g2, "adjacency")
}
