% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{dist_nvd}
\alias{dist_nvd}
\title{Pairwise Distance Matrix Between Two Samples of Networks}
\usage{
dist_nvd(x, y = NULL, representation = "adjacency", distance = "frobenius")
}
\arguments{
\item{x}{A \code{\link[base]{list}} of \code{\link[igraph]{igraph}} objects
or matrix representations of underlying networks from a given first
population.}

\item{y}{A \code{\link[base]{list}} of \code{\link[igraph]{igraph}} objects
or matrix representations of underlying networks from a given second
population.}

\item{representation}{A string specifying the desired type of representation,
among: \code{"adjacency"}, \code{"laplacian"}, \code{"modularity"} or
\code{"graphon"}. Default is \code{"laplacian"}.}

\item{distance}{A string specifying the chosen distance for calculating the
test statistic, among: \code{"hamming"}, \code{"frobenius"},
\code{"spectral"} and \code{"root-euclidean"}. Default is
\code{"frobenius"}.}
}
\value{
A matrix of dimension \eqn{(n1+n2) \times (n1+n2)} containing the
distances between all the elements of the two samples put together.
}
\description{
This function computes the matrix of pairwise distances between all the
elements of the two samples put together. The cardinality of the fist sample
is denoted by \eqn{n1} and that of the second one is denoted by \eqn{n2}.
}
\examples{
x <- nvd("smallworld", 10)
y <- nvd("pa", 10)
dist_nvd(x, y, "adjacency", "spectral")
}
