% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logic_map.R
\name{logicMap}
\alias{logicMap}
\title{Logic Map}
\usage{
logicMap(x, base.colour, start.colour, end.colour, names = NULL, newValue,
  default.colour = TRUE, no.label = FALSE)
}
\arguments{
\item{x}{This is taken from the logic derived using the igraph package.}

\item{base.colour}{This is the colour of all the nodes if no colour is specified}

\item{start.colour}{This is the colour of the first node}

\item{end.colour}{This is the colour of the last node}

\item{names}{If names=NUll then use default names in the package}

\item{newValue}{This is the value of the number of nodes from the logic}

\item{default.colour}{If TRUE, then the colours of the node will not change. If FALSE, the colours of the node will change.}

\item{no.label}{If no.labels is TRUE, then it will not print the names in the nodes. If FALSE, then it will be numeric values.}
}
\value{
The map item based on the logic of the igraph package
}
\description{
This function is used to change the node display.
}
\details{
This functions is embedded with \code{check.graph}, \code{edge.v}, \code{colour_display}. For example, you can use this function to add in names inside the node, or change the width of the edge, or to include the labels in the nodes given by the names arg. Generally, it is used for the assisting in the design of the network maze

This allow us to create a map with close looped form
}
\examples{
logic <- nodeLogic(value = 8, type= "circuit", itemFamily= 1)
names <- c('a','b','c','d','e','f','g')
logicMap(logic, no.label=FALSE, names=names)
}
\author{
Aiden Loe
}
