% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatplot.netmeta.R
\name{heatplot.netmeta}
\alias{heatplot.netmeta}
\title{Heat Plot}
\usage{
\method{heatplot}{netmeta}(
  x,
  pooled = ifelse(x$random, "random", "common"),
  seq = x$seq,
  nchar.trts = x$nchar.trts,
  low.colour = "red",
  mid.colour = "white",
  high.colour = "springgreen4",
  size = 6,
  size.trt = 16,
  size.axis = 12,
  digits = gs("digits.forest"),
  backtransf = x$backtransf,
  ...
)
}
\arguments{
\item{x}{An object of class \code{netmeta}.}

\item{pooled}{A character string indicating whether results for the
common (\code{"common"}) or random effects model
(\code{"random"}) should be plotted. Can be abbreviated.}

\item{seq}{A character or numerical vector specifying the sequence
of treatments in rows and columns of the heat plot.}

\item{nchar.trts}{A numeric defining the minimum number of
characters used to create unique treatment names.}

\item{low.colour}{A string indicating the colour of low relative
treatment effects for the heat plot (e.g odds ratio of ~0.5)}

\item{mid.colour}{A string indicating the colour of null relative
treatment effects for the heat plot (e.g odds ratio of ~1.0).}

\item{high.colour}{A string indicating the colour of high relative
treatment effects for the heat plot (e.g odds ratio of ~2.0).}

\item{size}{The size of cell entries with the relative treatment
effect and confidence intervals.}

\item{size.trt}{The size of treatment names placed on the top and
left of the plot.}

\item{size.axis}{The size of labels on the top and left of the plot}

\item{digits}{Minimal number of significant digits for treatment
effects and confidence intervals, see \code{print.default}.}

\item{backtransf}{A logical indicating whether results should be
back transformed in forest plots. If \code{backtransf = TRUE},
results for \code{sm = "OR"} are presented as odds ratios rather
than log odds ratios, for example.}

\item{\dots}{Additional arguments.}
}
\value{
League heat plot, where a color scale is used to represent the
values of relative treatment effects.
}
\description{
Produces a heat plot containing treatment estimates with confidence
intervals for all possible pairwise comparisons.
}
\examples{
data(Senn2013)

# Only consider first five studies (to reduce runtime of example)
#
studies <- unique(Senn2013$studlab)
Senn2013.5 <- subset(Senn2013, studlab \%in\% studies[1:5])

# Conduct random effects network meta-analysis with
# placebo as reference treatment
#
net1 <- netmeta(TE, seTE, treat1.long, treat2.long, studlab,
  data = Senn2013.5, sm = "MD", common = FALSE, reference = "plac")
      
# Generate a heat plot (with abbreviated treatment labels)
#
heatplot(net1, nchar.trts = 4) 

}
\keyword{hplot}
