% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repeatcv.R
\name{repeatcv}
\alias{repeatcv}
\title{Repeated nested CV}
\usage{
repeatcv(
  expr,
  n = 5,
  repeat_folds = NULL,
  keep = TRUE,
  extra = FALSE,
  progress = TRUE,
  rep.cores = 1L
)
}
\arguments{
\item{expr}{An expression containing a call to \code{\link[=nestcv.glmnet]{nestcv.glmnet()}},
\code{\link[=nestcv.train]{nestcv.train()}}, \code{\link[=nestcv.SuperLearner]{nestcv.SuperLearner()}} or \code{\link[=outercv]{outercv()}}.}

\item{n}{Number of repeats}

\item{repeat_folds}{Optional list containing fold indices to be applied to
the outer CV folds.}

\item{keep}{Logical whether to save repeated outer CV predictions for ROC
curves etc.}

\item{extra}{Logical whether additional performance metrics are gathered for
binary classification models. See \code{\link[=metrics]{metrics()}}.}

\item{progress}{Logical whether to show progress.}

\item{rep.cores}{Integer specifying number of cores/threads to invoke.}
}
\value{
List of S3 class 'repeatcv' containing:
\item{call}{the model call}
\item{result}{matrix of performance metrics}
\item{output}{(if \code{keep = TRUE}) a matrix or dataframe containing the outer CV
predictions from each repeat}
\item{roc}{(binary classification models only) a ROC curve object based on
predictions across all repeats as returned in \code{output}, generated by
\code{pROC::roc()}}
}
\description{
Performs repeated calls to a \code{nestedcv} model to determine performance across
repeated runs of nested CV.
}
\details{
We recommend using this with the R pipe \verb{|>} (see examples).

When comparing models, it is recommended to fix the sets of outer CV folds
used across each repeat for comparing performance between models. The
function \code{\link[=repeatfolds]{repeatfolds()}} can be used to create a fixed set of outer CV folds
for each repeat.

Parallelisation over repeats is performed using \code{parallel::mclapply} (not
available on windows). Beware that \code{cv.cores} can still be set within calls
to \code{nestedcv} models (= nested parallelisation). This means that \code{rep.cores}
x \code{cv.cores} number of processes/forks will be spawned, so be careful not to
overload your CPU. In general parallelisation of repeats using \code{rep.cores} is
faster than parallelisation using \code{cv.cores}.
}
\examples{
\donttest{
data("iris")
dat <- iris
y <- dat$Species
x <- dat[, 1:4]

res <- nestcv.glmnet(y, x, family = "multinomial", alphaSet = 1,
                     n_outer_folds = 4) |>
       repeatcv(3, rep.cores = 2)
res
summary(res)

## set up fixed fold indices
set.seed(123, "L'Ecuyer-CMRG")
folds <- repeatfolds(y, repeats = 3, n_outer_folds = 4)
res <- nestcv.glmnet(y, x, family = "multinomial", alphaSet = 1,
                     n_outer_folds = 4) |>
       repeatcv(3, repeat_folds = folds, rep.cores = 2)
res
}
}
