% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stratiplot.download.R
\name{Stratiplot.download}
\alias{Stratiplot.download}
\title{Palaeoecological stratigraphic diagrams}
\usage{
\method{Stratiplot}{download}(x, yaxis = "age", method = "none",
  group = NULL, ...)
}
\arguments{
\item{x}{A \code{download} object.}

\item{yaxis}{One of the columns in \code{sample.meta}, including \code{depth}, \code{age}, \code{age.younger}, or \code{age.older}, default \code{age}.}

\item{method}{An option for axis transformation using \code{tran} from the \code{analogue} package.  \code{"none"} by default.}

\item{group}{An ecological group from the taxon table.}

\item{...}{variables to be passed to \code{Stratiplot}.}
}
\value{
A \code{trellis} object.
}
\description{
Draws paleoecological diagrams from a \code{download} object.  Allows control of variable type (using the \code{tran} function from the \code{analogue} package), and taxonomic grouping.
}
\details{
A wrapper for the \code{analogue} package's \code{Stratiplot} function.  Allowing the user to plot a stratigraphic diagram directly from a \code{download} object.
}
\examples{
\dontrun{
lake_o_dl <- get_download(15925)
Stratiplot(lake_o_dl[[1]])
}
}

