% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neg.cor.R
\name{neg.cor}
\alias{neg.cor}
\alias{print.neg.cor}
\title{Test for Lack of Association between Two Continuous Normally Distributed Variables: Equivalence-based correlation tests}
\usage{
neg.cor(
  v1,
  v2,
  eiU,
  eiL,
  alpha = 0.05,
  na.rm = TRUE,
  plot = TRUE,
  data = NULL,
  saveplot = FALSE,
  seed = NA,
  ...
)

\method{print}{neg.cor}(x, ...)
}
\arguments{
\item{v1}{the first variable of interest}

\item{v2}{the second variable of interest}

\item{eiU}{the upper bound of the equivalence interval, in terms of the magnitude of a correlation}

\item{eiL}{the lower bound of the equivalence interval, in terms of the magnitude of a correlation}

\item{alpha}{desired alpha level}

\item{na.rm}{logical; remove missing values?}

\item{plot}{whether or not to print graphics of the results (default = TRUE)}

\item{data}{data frame where two variables (v1 and y) are contained - optional}

\item{saveplot}{saving plots (default = FALSE)}

\item{seed}{optional argument to set seed}

\item{...}{additional arguments to be passed}

\item{x}{object of class \code{neg.cor}}
}
\value{
A \code{list} including the following:
\itemize{
  \item \code{corxy} Sample correlation value
  \item \code{eiL} Lower bound of the negligible effect (equivalence) interval
  \item \code{eiU} Upper bound of the negligible effect (equivalence) interval
  \item \code{nresamples} Number of resamples for the bootstrapping procedure
  \item \code{q1} Lower bound of the confidence interval for the correlation
  \item \code{q2} Upper bound of the confidence interval for the correlation
  \item \code{PD} Proportional distance
  \item \code{CIPDL} Lower bound of the 1-alpha CI for the PD
  \item \code{CIPDU} Upper bound of the 1-alpha CI for the PD
  \item \code{alpha} Nominal Type I error rate
}
}
\description{
Function performs an equivalence based test of lack of association with resampling.
}
\details{
From Goertzen, J. R., & Cribbie, R. A. (2010). Detecting a lack of association. British Journal of Mathematical and Statistical Psychology, 63(3), 527–537

This function evaluates whether a negligible relationship exists among two continuous variables.

The statistical test is based on a bootstrap-generated 1-2*alpha CI for the correlation; in other words, does the 1-2*alpha CI for the falls completely within the negligible effect (equivalence) interval.

The user needs to specify the lower and upper bounds of the negligible effect (equivalence) interval (eiL,eiU). Since we working in a correlation magnitude, setting these bounds requires estimating the minimally meaningful effect size (MMES); in this case, the minimally meaningful correlation (e.g., eiL = - .3, eiU = .3).

The 'plot' argument, if TRUE, will generate a plot of the observed effect (correlation) with the associated 1-2*alpha CI, along with a plot of the PD and the associated 1-alpha CI.
}
\examples{
#Negligible correlation test between v1 and v2
#with an interval of ei=(-.2.2)
v1 <- rnorm(50)
v2 <- rnorm(50)
cor(v1, v2)
neg.cor(v1 = v1, v2 = v2, eiU = .2, eiL = -.2)
}
\author{
Rob Cribbie \email{cribbie@yorku.ca}
  Phil Chalmers \email{rphilip.chalmers@gmail.com} and
  Nataly Beribisky \email{natalyb1@yorku.ca}
}
