% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot-ncvreg.R
\name{boot_ncvreg}
\alias{boot_ncvreg}
\title{Hybrid Bootstrap Confidence Intervals}
\usage{
boot_ncvreg(
  X,
  y,
  fit,
  lambda,
  sigma2,
  cluster,
  seed,
  nboot = 1000,
  penalty = "lasso",
  level = 0.95,
  gamma = switch(penalty, SCAD = 3.7, 3),
  alpha = 1,
  returnCV = FALSE,
  return_boot = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{X}{The design matrix, without an intercept. \code{boot_ncvreg}
standardizes the data and includes an intercept by default.}

\item{y}{The response vector.}

\item{fit}{(optional) An object of class \code{ncvreg} or
\code{cv.ncvreg}. An object of class \code{ncvreg}
provides data, penalty choices, and \code{lambda} sequence to
\code{boot_ncvreg}. An object of class \code{cv.ncvreg} can in
addition can provide information for selecting \code{lambda}
and estimating \code{sigma2}. If provided, \code{y} should not
be provided and \code{X} should only be provided if \code{fit}
does not contain \code{X}.}

\item{lambda}{(optional) The value of lambda to provide interval estimates
for. If left missing will be selected using CV. If user wants
to set the lambda sequence used to select \code{lambda} via
cross validation, they should call \code{cv.ncvreg} separately
and pass the resulting object to \code{fit}.}

\item{sigma2}{(optional) The variance to use for the Hybrid sampling. If
left missing will be set using the estimator suggested by Reid
et. al. (2016) using CV.}

\item{cluster}{Bootstrapping and \code{cv.ncvreg} (if applicable) can be run
in parallel across a cluster using the \strong{parallel} package.
The cluster must be set up in advance using the
\code{\link[parallel:makeCluster]{parallel::makeCluster()}} function from that package. The
cluster must then be passed to \code{boot_ncvreg}.}

\item{seed}{You may set the seed of the random number generator in order
to obtain reproducible results. This is set for the overall
process. If the user wishes to set a seed specifically for
\code{cv.ncvreg} they should call it separately then pass the
fitted object as an argument to \code{fit}.}

\item{nboot}{The number of bootstrap replications to use.}

\item{penalty}{The penalty to be applied to the model.  Either "lasso" (the
default), "MCP", or "SCAD".}

\item{level}{The confidence level required.}

\item{gamma}{The tuning parameter of the MCP/SCAD penalty
(see \code{ncvreg} for details). Default is 3 for MCP and 3.7
for SCAD. Ignored if fit is provided.}

\item{alpha}{Tuning parameter for the Elastc net estimator which controls
the relative contributions from the lasso/MCP/SCAD penalty and
the ridge, or L2 penalty. \code{alpha=1} is equivalent to
lasso/MCP/SCAD penalty, while \code{alpha=0} would be equivalent to
ridge regression. However, \code{alpha=0} is not supported; \code{alpha}
may be arbitrarily small, but not exactly 0. Ignored if fit is
provided.}

\item{returnCV}{If \code{TRUE}, the \code{cv.ncvreg} fit will be returned
(if applicable).}

\item{return_boot}{If \code{TRUE}, the bootstrap draws will be returned.}

\item{verbose}{If \code{FALSE}, non-essential messages are suppressed.}

\item{...}{named arguments to be passed to \code{ncvreg} and
\code{cv.ncvreg}.}
}
\value{
A list with:
\describe{
\item{confidence_intervals}{A \code{data.frame} with the original point estimates along with lower and upper bounds of Hybrid CIs.}
\item{lambda}{The value of \code{lambda} the \code{confidence_intervals} were constructed at.}
\item{sigma2}{The value of \code{sigma2} used for the Hybrid bootstrap sampling.}
\item{penalty}{The penalty the intervals correspond to.}
\item{alpha}{The tuning parameter for the Enet estimator used.}
\item{level}{The confidence level the intervals correspond to.}
}
If a penalty other than "lasso" is used,
\describe{
\item{gamma}{The tuning parameter for MCP/SCAD penalty.}
}
If \code{returnCV} is \code{TRUE} and a \code{cv.ncvreg} object was fit or supplied
\describe{
\item{cv.ncvreg}{The \code{cv.ncvreg} fit used to estimate \code{lambda} and \code{sigma2} (if applicable).}
}
If \code{return_boot} is \code{TRUE}
\describe{
\item{boot_draws}{A \code{data.frame} of the Hybrid bootstrap draws are returned.}
}
}
\description{
Performs a hybrid bootstrapping approach to construct quantile based
confidence intervals around the original lasso/MCP/SCAD estimator.
Specifically, a traditional pairs bootstrap is performed with 1 adjustment:
if the bootstrap sample for a given covariate is zero, a random sample from
the full conditional posterior is used as the bootstrap sample instead.
This avoids the creation of intervals with endpoints exactly equal to zero.
}
\details{
The resulting intervals WILL NOT have exact nominal coverage for all
covariates. They are instead constructed in a way that overall coverage will
be approximately equal to nominal so long as the true distribution of betas
is Laplace and the covariates are independent. That said, in practice,
average coverage is fairly robust to these assumptions.

Note: Draws from the full conditional posterior are approximations for
MCP/SCAD or when \code{alpha} is not 1.
}
\examples{
data(Prostate)
X <- Prostate$X
y <- Prostate$y
boot_ncvreg(X, y, level = 0.8)
}
