% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neuronlist.R
\name{as.data.frame.neuronlist}
\alias{as.data.frame.neuronlist}
\alias{data.frame<-}
\alias{data.frame<-.neuronlist}
\title{Get or set the attached data.frame of a neuronlist}
\usage{
\method{as.data.frame}{neuronlist}(x, row.names = names(x),
  optional = FALSE, ...)

data.frame(x) <- value

\method{data.frame}{neuronlist}(x) <- value
}
\arguments{
\item{x}{neuronlist to convert}

\item{row.names}{row names (defaults to names of objects in neuronlist, which
is nearly always what you want.)}

\item{optional}{ignored in this method}

\item{...}{additional arguments passed to \code{\link{data.frame}} (see 
examples)}

\item{value}{The new data.frame to be attached to \code{x}}
}
\value{
for \code{as.data.frame.neuronlist}, a \code{data.frame} with
  length(x) rows, named according to names(x) and containing the columns from
  the attached data.frame, when present.

for \code{data.frame<-.neuronlist}, a neuronlist with the attached
  data.frame.
}
\description{
For \code{as.data.frame}, when there is no attached data.frame the result 
will be a data.frame with 0 columns but an appropriate number of rows, named by
the objects in the neuronlist.

\code{data.frame<-} methods set the data frame attached to an 
  object. At present this is only used for neuronlist objects.
}
\examples{
head(as.data.frame(kcs20))

# add additional variables
str(as.data.frame(kcs20, i=seq(kcs20), abc=LETTERS[seq(kcs20)]))
# stop character columns being turned into factors
newdf <- as.data.frame(kcs20, i=seq(kcs20), abc=LETTERS[seq(kcs20)], 
  stringsAsFactors=FALSE)
str(newdf)
data.frame(kcs20)=newdf
}
\seealso{
\code{\link{data.frame}}, \code{\link{neuronlist}}
}

