% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hxsurf.R
\name{pointsinside}
\alias{pointsinside}
\alias{pointsinside.default}
\title{Find which points of an object are inside a surface}
\usage{
pointsinside(x, surf, ...)

\method{pointsinside}{default}(x, surf, ..., rval = c("logical", "distance",
  "mesh3d"))
}
\arguments{
\item{x}{an object with 3D points.}

\item{surf}{an \code{hxsurf} or \code{mesh3d} object defining the reference 
surface.}

\item{...}{additional arguments for methods, eventually passed to as.mesh3d.}

\item{rval}{what to return.}
}
\value{
A vector of logical values or distances equal to the number of points
  in x or the \code{mesh3d} object returned by \code{Rvcg::vcgClost}.
}
\description{
Find which points of an object are inside a surface
}
\details{
Note that \code{hxsurf} surface objects will be converted to 
  \code{mesh3d} before being passed to \code{Rvcg::vcgClost}, so if you are 
  testing repeatedly against the same surface, it may make sense to 
  pre-convert.
  
  Note also that if the point is some distance (> 2 twice the diagonal 
  boundingbox of the mesh) then the distance will be returned as NA (or 1e12 
  for older versions of the \code{Rvcg} package). This behaviour is defined
  by the \code{Rvcg::vcgClost} function.
}

