% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{request_signal}
\alias{request_signal}
\title{Request and Signal a Condition Variable (RPC Client for Req/Rep Protocol)}
\usage{
request_signal(
  context,
  data,
  cv,
  send_mode = c("serial", "raw", "next"),
  recv_mode = c("serial", "character", "complex", "double", "integer", "logical",
    "numeric", "raw", "string"),
  timeout = NULL
)
}
\arguments{
\item{context}{a Context.}

\item{data}{an object (if send_mode = \sQuote{raw}, a vector).}

\item{cv}{(optional) a \sQuote{conditionVariable} to signal when the async
receive is complete.}

\item{send_mode}{[default 'serial'] character value or integer equivalent -
one of \sQuote{serial} (1L) to send serialised R objects, \sQuote{raw}
(2L) to send atomic vectors of any type as a raw byte vector, or
\sQuote{next} (3L) - see \sQuote{Send Modes} section below.}

\item{recv_mode}{[default 'serial'] character value or integer equivalent -
one of \sQuote{serial} (1L), \sQuote{character} (2L), \sQuote{complex}
(3L), \sQuote{double} (4L), \sQuote{integer} (5L), \sQuote{logical} (6L),
\sQuote{numeric} (7L), \sQuote{raw} (8L), or \sQuote{string} (9L). The
default \sQuote{serial} means a serialised R object; for the other
modes, received bytes are converted into the respective mode.
\sQuote{string} is a faster option for length one character vectors.}

\item{timeout}{[default NULL] integer value in milliseconds or NULL, which
applies a socket-specific default, usually the same as no timeout.}
}
\description{
Deprecated function - use \code{request} instead.
}
\keyword{internal}
