% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgas_nigeria.R
\name{lgas_ng}
\alias{lgas_ng}
\title{List Local Government Areas}
\usage{
lgas_ng(ng.state = NA_character_)
}
\arguments{
\item{ng.state}{Character; State(s) in the Federation of Nigeria. Default is
\code{NA_character_}.}
}
\value{
If length of \code{ng.state} == 1L, a character vector containing 
the names of Local Government Areas; otherwise a named list whose elements 
are character vectors of the LGAs in each state.
}
\description{
List Local Government Areas
}
\examples{
how_many_lgas <- function(state) {
  require(naijR)
  stopifnot(state \%in\% states())
  cat(sprintf("No. of LGAs in \%s State:", state),
    length(lgas_ng(state)),
    fill = TRUE)
}
how_many_lgas("Sokoto")
how_many_lgas("Ekiti")

}
